/*
	This file is part of Warzone 2100.
	Copyright (C) 2005-2019  Warzone 2100 Project

	Warzone 2100 is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Warzone 2100 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Warzone 2100; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

#if defined(__clang__)
	#pragma clang diagnostic ignored "-Wunneeded-internal-declaration" // warning: function 'yyinput' is not needed and will not be emitted
#elif defined(__GNUC__)
	#if 7 <= __GNUC__
		#pragma GCC diagnostic ignored "-Wnull-dereference"
	#endif
#endif

#line 2 "chat_lexer.cpp"

#line 4 "chat_lexer.cpp"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer chat__create_buffer
#define yy_delete_buffer chat__delete_buffer
#define yy_flex_debug chat__flex_debug
#define yy_init_buffer chat__init_buffer
#define yy_flush_buffer chat__flush_buffer
#define yy_load_buffer_state chat__load_buffer_state
#define yy_switch_to_buffer chat__switch_to_buffer
#define yyin chat_in
#define yyleng chat_leng
#define yylex chat_lex
#define yylineno chat_lineno
#define yyout chat_out
#define yyrestart chat_restart
#define yytext chat_text
#define yywrap chat_wrap
#define yyalloc chat_alloc
#define yyrealloc chat_realloc
#define yyfree chat_free

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */
#include "lib/framework/frame.h"
/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

#include "lib/framework/wzglobal.h"

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined(HAVE_INTTYPES_H) || (defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L)

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types.
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t;
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE chat_restart(chat_in  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int chat_leng;

extern FILE *chat_in, *chat_out;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE chat_lex.
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-chat_lineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < chat_leng; ++yyl )\
                    if ( chat_text[yyl] == '\n' )\
                        --chat_lineno;\
            }while(0)

/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up chat_text. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up chat_text again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via chat_restart()), so that the user can continue scanning by
	 * just pointing chat_in at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when chat_text is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int chat_leng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow chat_wrap()'s to do buffer switches
 * instead of setting up a fresh chat_in.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void chat_restart (FILE *input_file  );
void chat__switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE chat__create_buffer (FILE *file,int size  );
void chat__delete_buffer (YY_BUFFER_STATE b  );
void chat__flush_buffer (YY_BUFFER_STATE b  );
void chat_push_buffer_state (YY_BUFFER_STATE new_buffer  );
void chat_pop_buffer_state (void );

static void chat_ensure_buffer_stack (void );
static void chat__load_buffer_state (void );
static void chat__init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER chat__flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE chat__scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE chat__scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE chat__scan_bytes (yyconst char *bytes,int len  );

void *chat_alloc (yy_size_t  );
void *chat_realloc (void *,yy_size_t  );
void chat_free (void *  );

#define yy_new_buffer chat__create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        chat_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            chat__create_buffer(chat_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        chat_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            chat__create_buffer(chat_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *chat_in = (FILE *) 0, *chat_out = (FILE *) 0;

typedef int yy_state_type;

extern int chat_lineno;

int chat_lineno = 1;

extern char *chat_text;
#define yytext_ptr chat_text

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
[[ noreturn ]] static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up chat_text.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	chat_leng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 85
#define YY_END_OF_BUFFER 86
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[262] =
    {   0,
       83,   83,   86,   85,   84,    4,   85,    8,   85,    5,
        1,    6,    7,    3,    9,   83,   83,   83,   83,   83,
       83,   83,   42,   83,   83,   83,   83,   83,   83,   83,
       83,   73,   83,   83,   83,    4,    2,    1,    5,    1,
       83,    3,   83,   83,   13,   14,   83,   83,   83,   83,
       83,   83,   83,   26,   83,   83,   83,   83,   33,   83,
       83,   83,   83,    0,   44,   83,   83,   47,   83,   83,
       50,   83,   53,   54,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   15,   16,   83,   83,   83,   83,

       83,   83,   83,   83,   83,   83,   29,   31,   83,   83,
       36,   83,   39,   83,   83,   83,   43,   83,   83,   83,
       83,   51,    0,   83,   83,   83,   83,   83,   59,   83,
       83,   83,   83,   64,   65,   83,   83,   83,   83,   83,
       72,   83,   83,   83,   83,   78,   80,   81,   82,   83,
       83,   12,   19,   83,   83,   83,    0,   83,   24,   83,
       27,   28,   83,   83,   83,   83,   83,   38,   40,   41,
       83,    0,   48,   49,    0,   83,   83,   83,   83,   83,
       83,   83,   63,   66,   83,   68,   69,   83,   83,   83,
       76,   83,   79,   83,   11,   83,   83,   83,   22,   83,

       83,   30,   83,   34,   35,   37,   83,   46,    0,   55,
       83,   57,   83,   60,   83,   62,   83,   83,   74,   75,
       77,   83,   17,   20,   83,   23,   83,   83,   45,    0,
       83,   83,   83,   67,    0,   71,   83,   83,   83,   25,
       32,    0,   83,   58,   61,    0,   83,   83,   21,    0,
       83,    0,   83,   18,   52,   83,   70,   83,   56,   10,
        0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    2,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    3,    4,    1,    1,    1,    1,    1,    5,    1,
        1,    1,    1,    6,    7,    8,    1,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,   10,   11,    1,
        1,    1,   12,    1,   13,   14,   15,   16,   17,   18,
       19,   20,   21,   22,   23,   24,   25,   26,   27,   28,
       29,   30,   31,   32,   33,   34,   35,   22,   36,   22,
        1,    1,    1,    1,   22,    1,   37,   38,   39,   40,

       41,   42,   43,   44,   45,   22,   46,   47,   48,   49,
       50,   51,   52,   53,   54,   55,   56,   57,   58,   22,
       59,   22,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[60] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    1,
        1,    1,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2
    } ;

static yyconst flex_int16_t yy_base[263] =
    {   0,
        0,    0,  150,  523,  523,  139,   29,  523,  128,  125,
      120,  523,  523,  113,   66,   44,   52,   77,    0,   52,
       82,  107,   57,   69,   99,  111,  113,  118,  136,  139,
       43,   46,   46,  147,  137,   72,  523,   66,   66,   62,
        0,   58,  158,   56,    0,  157,  122,  126,   68,   96,
      149,  153,  169,    0,  158,  162,  166,  169,  183,  105,
      176,  179,  188,  189,    0,  186,  186,    0,  190,  188,
      186,   65,  196,    0,  212,  196,  220,  226,  215,  205,
      245,  217,  240,  217,  244,  227,  224,  235,  247,  263,
      233,  248,  254,  237,    0,    0,  243,  269,  268,  263,

       62,  260,  281,  269,  273,  286,  289,  276,  283,  285,
        0,  292,    0,  295,  288,  297,  523,  287,   61,  302,
      304,    0,  308,  302,  311,  299,  316,  307,    0,  322,
      307,  325,  325,    0,    0,  329,  317,  323,  335,  328,
        0,  323,  332,  327,  330,  341,    0,    0,    0,  334,
      335,    0,    0,  352,  344,  352,  341,  358,    0,  359,
        0,    0,  364,  363,  367,  376,  361,    0,    0,    0,
      377,  364,    0,    0,  370,  381,  383,  372,  382,  370,
      386,  379,    0,    0,  378,    0,    0,  389,  384,  386,
        0,  402,    0,  396,    0,  400,  400,  407,  523,  400,

      418,    0,  410,    0,    0,    0,  405,  523,  406,    0,
      410,    0,  416,    0,  415,    0,  416,  445,    0,    0,
        0,  437,  430,    0,  428,    0,  432,  437,    0,  428,
      430,  444,  449,    0,  433,    0,  439,  446,  448,    0,
        0,  442,  458,    0,    0,  455,  462,  466,    0,  469,
      461,  456,  459,    0,  523,  471,  523,  481,    0,    0,
      523,   62
    } ;

static yyconst flex_int16_t yy_def[263] =
    {   0,
      261,    1,  261,  261,  261,  261,  261,  261,  261,  261,
      262,  261,  261,  261,  262,  262,  262,  262,  262,  262,
      262,  262,  262,  262,  262,  262,  262,  262,  262,  262,
      262,  262,  262,  262,  262,  261,  261,  261,  261,  262,
      262,  261,  262,  262,  262,  262,  262,  262,  262,  262,
      262,  262,  262,  262,  262,  262,  262,  262,  262,  262,
      262,  262,  262,  261,  262,  262,  262,  262,  262,  262,
      262,  262,  262,  262,  262,  262,  262,  262,  262,  262,
      262,  262,  262,  262,  262,  262,  262,  262,  262,  262,
      262,  262,  262,  262,  262,  262,  262,  262,  262,  262,

      262,  262,  262,  262,  262,  262,  262,  262,  262,  262,
      262,  262,  262,  262,  262,  262,  261,  262,  262,  262,
      262,  262,  261,  262,  262,  262,  262,  262,  262,  262,
      262,  262,  262,  262,  262,  262,  262,  262,  262,  262,
      262,  262,  262,  262,  262,  262,  262,  262,  262,  262,
      262,  262,  262,  262,  262,  262,  261,  262,  262,  262,
      262,  262,  262,  262,  262,  262,  262,  262,  262,  262,
      262,  261,  262,  262,  261,  262,  262,  262,  262,  262,
      262,  262,  262,  262,  262,  262,  262,  262,  262,  262,
      262,  262,  262,  262,  262,  262,  262,  262,  261,  262,

      262,  262,  262,  262,  262,  262,  262,  261,  261,  262,
      262,  262,  262,  262,  262,  262,  262,  262,  262,  262,
      262,  262,  262,  262,  262,  262,  262,  262,  262,  261,
      262,  262,  262,  262,  261,  262,  262,  262,  262,  262,
      262,  261,  262,  262,  262,  261,  262,  262,  262,  261,
      262,  261,  262,  262,  261,  262,  261,  262,  262,  262,
        0,  261
    } ;

static yyconst flex_int16_t yy_nxt[583] =
    {   0,
        4,    5,    5,    6,    7,    8,    9,   10,   11,   12,
       13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
       23,   19,   19,   24,   25,   26,   27,   28,   19,   29,
       30,   31,   32,   33,   34,   35,   15,   16,   17,   18,
       19,   20,   21,   22,   23,   19,   24,   25,   26,   27,
       28,   19,   29,   30,   31,   32,   33,   34,   35,   37,
       49,   64,   85,   41,   51,  172,  157,  123,   52,   42,
       40,   86,   56,   39,   38,   36,   50,   87,   57,   94,
       99,   66,   37,   43,   49,   67,   85,   65,   51,   44,
       45,   46,   52,   53,   86,   47,   56,   48,   58,   50,

       87,   57,   94,   54,   99,   66,   55,   43,   59,   67,
       65,   60,   44,   45,   46,   68,  100,   53,   47,   61,
       48,  112,   58,   62,   42,   69,   54,   70,   40,   55,
       72,   59,   39,   63,   60,   73,   38,   71,   74,   68,
      100,   75,   36,   61,   76,  112,   97,   62,   69,  261,
       77,   70,   78,   90,   72,   81,   63,   98,   73,   88,
       71,   74,   79,   91,   75,   82,   89,   76,   80,   97,
       83,   84,   95,   77,  101,   92,   78,   90,  102,   81,
       98,  103,  261,   88,  105,   79,   91,  106,   82,   93,
       89,   80,   96,   83,   84,  107,   95,  101,  104,   92,

      108,  102,  115,  109,  121,  103,  113,  105,  110,  114,
      106,  116,   93,  117,  111,   96,  118,  119,  107,  120,
      122,  104,  124,  108,  125,  115,  126,  109,  121,  113,
      127,  110,  114,  132,  116,  133,  117,  111,  130,  118,
      119,  136,  120,  122,  128,  124,  139,  142,  125,  126,
      143,  129,  137,  127,  131,  144,  140,  132,  133,  134,
      141,  135,  130,  145,  136,  149,  138,  128,  150,  139,
      151,  142,  152,  143,  129,  146,  137,  131,  153,  144,
      140,  154,  155,  134,  141,  135,  156,  145,  149,  138,
      147,  158,  150,  148,  151,  152,  159,  261,  160,  146,

      161,  153,  162,  163,  167,  154,  155,  164,  165,  156,
      166,  168,  170,  147,  158,  169,  148,  171,  173,  174,
      159,  160,  175,  161,   73,  176,  162,  163,  167,  177,
      164,  165,  178,  166,  179,  168,  170,  180,  169,  181,
      171,  182,  173,  174,  183,  184,  175,   73,  185,  176,
      186,  187,  177,  188,  189,  190,  178,  179,  191,  192,
      193,  180,  181,  194,  195,  182,  196,  198,  183,  184,
      197,  185,  199,  186,  200,  187,  188,  189,  190,  201,
      202,  191,  192,  203,  193,  204,  194,  195,  205,  207,
      196,  198,  206,  197,  208,  199,  209,  210,  200,  211,

      261,  212,  213,  201,  202,  214,  215,  203,  216,  204,
      217,  218,  205,  207,  219,  206,  220,  208,  221,  209,
      222,  210,  223,  211,  212,  224,  213,  225,  214,  226,
      215,  216,  227,  217,  218,  228,  229,  219,  230,  220,
      231,  232,  221,  222,  233,  223,  234,  235,  224,  237,
      238,  225,  226,  239,  240,  241,  227,  242,  228,  229,
      243,  230,  244,  231,  232,  245,  249,  233,  246,  234,
      247,  248,  250,  237,  238,  236,  239,  240,  251,  241,
      242,  252,  253,  243,  254,  255,  244,  256,  257,  245,
      249,  246,  258,  247,  248,  250,  259,  260,  236,  261,

      261,  261,  251,  261,  252,  261,  253,  261,  254,  255,
      256,  257,  261,  261,  261,  258,  261,  261,  261,  259,
      261,  260,    3,  261,  261,  261,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  261,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  261,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  261,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  261,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  261,  261,  261,  261,  261,
      261,  261
    } ;

static yyconst flex_int16_t yy_chk[583] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    7,
       16,   23,   31,  262,   17,  119,  101,   72,   17,   42,
       40,   32,   20,   39,   38,   36,   16,   33,   20,   44,
       49,   24,    7,   15,   16,   24,   31,   23,   17,   15,
       15,   15,   17,   18,   32,   15,   20,   15,   21,   16,

       33,   20,   44,   18,   49,   24,   18,   15,   21,   24,
       23,   21,   15,   15,   15,   25,   50,   18,   15,   22,
       15,   60,   21,   22,   14,   25,   18,   26,   11,   18,
       27,   21,   10,   22,   21,   27,    9,   26,   27,   25,
       50,   28,    6,   22,   28,   60,   47,   22,   25,    3,
       28,   26,   29,   35,   27,   30,   22,   48,   27,   34,
       26,   27,   29,   35,   28,   30,   34,   28,   29,   47,
       30,   30,   46,   28,   51,   43,   29,   35,   52,   30,
       48,   53,    0,   34,   55,   29,   35,   56,   30,   43,
       34,   29,   46,   30,   30,   57,   46,   51,   53,   43,

       58,   52,   62,   59,   70,   53,   61,   55,   59,   61,
       56,   63,   43,   64,   59,   46,   66,   67,   57,   69,
       71,   53,   73,   58,   75,   62,   76,   59,   70,   61,
       76,   59,   61,   79,   63,   80,   64,   59,   78,   66,
       67,   82,   69,   71,   77,   73,   84,   86,   75,   76,
       87,   77,   83,   76,   78,   88,   85,   79,   80,   81,
       85,   81,   78,   89,   82,   91,   83,   77,   92,   84,
       93,   86,   94,   87,   77,   90,   83,   78,   97,   88,
       85,   98,   99,   81,   85,   81,  100,   89,   91,   83,
       90,  102,   92,   90,   93,   94,  103,    0,  104,   90,

      105,   97,  106,  107,  112,   98,   99,  108,  109,  100,
      110,  114,  116,   90,  102,  115,   90,  118,  120,  121,
      103,  104,  123,  105,  124,  125,  106,  107,  112,  126,
      108,  109,  127,  110,  128,  114,  116,  130,  115,  131,
      118,  132,  120,  121,  133,  136,  123,  124,  137,  125,
      138,  139,  126,  140,  142,  143,  127,  128,  144,  145,
      146,  130,  131,  150,  151,  132,  154,  156,  133,  136,
      155,  137,  157,  138,  158,  139,  140,  142,  143,  160,
      163,  144,  145,  164,  146,  165,  150,  151,  166,  171,
      154,  156,  167,  155,  172,  157,  175,  176,  158,  177,

        0,  178,  179,  160,  163,  180,  181,  164,  182,  165,
      185,  188,  166,  171,  189,  167,  190,  172,  192,  175,
      194,  176,  196,  177,  178,  197,  179,  198,  180,  200,
      181,  182,  201,  185,  188,  203,  207,  189,  209,  190,
      211,  213,  192,  194,  215,  196,  217,  218,  197,  222,
      223,  198,  200,  225,  227,  228,  201,  230,  203,  207,
      231,  209,  232,  211,  213,  233,  239,  215,  235,  217,
      237,  238,  242,  222,  223,  218,  225,  227,  243,  228,
      230,  246,  247,  231,  248,  250,  232,  251,  252,  233,
      239,  235,  253,  237,  238,  242,  256,  258,  218,    0,

        0,    0,  243,    0,  246,    0,  247,    0,  248,  250,
      251,  252,    0,    0,    0,  253,    0,    0,    0,  256,
        0,  258,  261,  261,  261,  261,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  261,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  261,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  261,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  261,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  261,  261,  261,  261,  261,
      261,  261
    } ;

/* Table of booleans, true if rule could match eol. */
static yyconst flex_int32_t yy_rule_can_match_eol[86] =
    {   0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0,     };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int chat__flex_debug;
int chat__flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *chat_text;
#line 1 "chat_lexer.lpp"
/*
	This file is part of Warzone 2100.
	Copyright (C) 2006-2008  Roman
	Copyright (C) 2006-2019  Warzone 2100 Project

	Warzone 2100 is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Warzone 2100 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Warzone 2100; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/
#line 21 "chat_lexer.lpp"
/** @file
 *
 *  Lexical analyser for multiplayer chat messages.
 */

#include "lib/framework/frame.h"

// FIXME: #include from src/
#include "src/scriptfuncs.h"

#include "lib/script/script.h"
#include "lib/script/chat_processing.h"

/* Get the Yacc definitions */
#include "chat_parser.h"

// fwrite declared with warn_unused_result, resulting in mysterious errors in "%%" on some distros.
static inline bool no_warn_unused_result(int ignore) { if (ignore) {} return true; }
#define fwrite(a, b, c, d) no_warn_unused_result(fwrite(a, b, c, d))

/* Maximum length for any TEXT value */
#ifndef YYLMAX
#define YYLMAX	255
#endif

#if defined(YY_FLEX_SUBMINOR_VERSION) && YY_FLEX_SUBMINOR_VERSION == 33
extern int chat_get_lineno(void);
extern FILE *chat_get_in(void);
extern FILE *chat_get_out(void);
extern int chat_get_leng(void);
extern char *chat_get_text(void);
extern void chat_set_lineno(int line_number);
extern void chat_set_in(FILE* in_str);
extern void chat_set_out(FILE* out_str);
extern int chat_get_debug(void);
extern void chat_set_debug(int bdebug);
extern int chat_lex_destroy(void);
#endif

/* Pointer to the input buffer */
static const char *pInputBuffer = NULL;
static const char *pEndBuffer = NULL;

static SDWORD playerIndex;

#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
      if (pInputBuffer != pEndBuffer) { \
        buf[0] = *(pInputBuffer++); result = 1; \
      } else { \
        buf[0] = EOF; result = YY_NULL; \
      }

#undef chat_getc
#define chat_getc() (pInputBuffer != pEndBuffer ? *(pInputBuffer++) : EOF)

#line 795 "chat_lexer.cpp"

#define INITIAL 0

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int chat_lex_destroy (void );

int chat_get_debug (void );

void chat_set_debug (int debug_flag  );

YY_EXTRA_TYPE chat_get_extra (void );

void chat_set_extra (YY_EXTRA_TYPE user_defined  );

FILE *chat_get_in (void );

void chat_set_in  (FILE * in_str  );

FILE *chat_get_out (void );

void chat_set_out  (FILE * out_str  );

int chat_get_leng (void );

char *chat_get_text (void );

int chat_get_lineno (void );

void chat_set_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int chat_wrap (void );
#else
extern int chat_wrap (void );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( chat_text, chat_leng, 1, chat_out )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( chat_in )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( chat_in ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, chat_in))==0 && ferror(chat_in)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(chat_in); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int chat_lex (void);

#define YY_DECL int chat_lex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after chat_text and chat_leng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;

#line 89 "chat_lexer.lpp"


	/* Match integer numbers */
#line 984 "chat_lexer.cpp"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! chat_in )
			chat_in = stdin;

		if ( ! chat_out )
			chat_out = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			chat_ensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				chat__create_buffer(chat_in,YY_BUF_SIZE );
		}

		chat__load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of chat_text. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 262 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 261 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < chat_leng; ++yyl )
				if ( chat_text[yyl] == '\n' )

    chat_lineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 92 "chat_lexer.lpp"
{ chat_lval.ival = atol(chat_text); return R_INTEGER; }
	YY_BREAK
/* Keywords - Terminals */
case 2:
YY_RULE_SETUP
#line 95 "chat_lexer.lpp"
{ return R_POSSESSION; }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 96 "chat_lexer.lpp"
{ return _T_QM; }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 97 "chat_lexer.lpp"
{ return _T_EM; }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 98 "chat_lexer.lpp"
{ return _T_FULLSTOP; }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 99 "chat_lexer.lpp"
{ return _T_COLON; };
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 100 "chat_lexer.lpp"
{ return _T_SEMICOLON; };
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 101 "chat_lexer.lpp"
{ return _T_COMMA; };
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 102 "chat_lexer.lpp"
{ return _T_A; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 103 "chat_lexer.lpp"
{ return _T_AFFIRMATIVE; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 104 "chat_lexer.lpp"
{ return _T_AFTER; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 105 "chat_lexer.lpp"
{ return _T_ALLY; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 106 "chat_lexer.lpp"
{ return _T_AM; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 107 "chat_lexer.lpp"
{ return _T_AN; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 108 "chat_lexer.lpp"
{ return _T_AND; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 109 "chat_lexer.lpp"
{ return _T_ANY; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 110 "chat_lexer.lpp"
{ return _T_ATTACK; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 111 "chat_lexer.lpp"
{ return _T_ATTACKING; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 112 "chat_lexer.lpp"
{ return _T_ARMY; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 113 "chat_lexer.lpp"
{ return _T_BEACON; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 114 "chat_lexer.lpp"
{ return _T_BUILDING; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 115 "chat_lexer.lpp"
{ return _T_CANT; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 116 "chat_lexer.lpp"
{ return _T_CENTER; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 117 "chat_lexer.lpp"
{ return _T_DEAD; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 118 "chat_lexer.lpp"
{ return _T_DERRICK; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 119 "chat_lexer.lpp"
{ return _T_DO; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 120 "chat_lexer.lpp"
{ return _T_DROP; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 121 "chat_lexer.lpp"
{ return _T_FINE; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 122 "chat_lexer.lpp"
{ return _T_FOR; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 123 "chat_lexer.lpp"
{ return _T_FORCE; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 124 "chat_lexer.lpp"
{ return _T_GET; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 125 "chat_lexer.lpp"
{ return _T_GETTING; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 126 "chat_lexer.lpp"
{ return _T_GO; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 127 "chat_lexer.lpp"
{ return _T_GOING; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 128 "chat_lexer.lpp"
{ return _T_GONNA; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 129 "chat_lexer.lpp"
{ return _T_GOT; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 130 "chat_lexer.lpp"
{ return _T_GREAT; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 131 "chat_lexer.lpp"
{ return _T_HAVE; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 132 "chat_lexer.lpp"
{ return _T_HAS; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 133 "chat_lexer.lpp"
{ return _T_HELP; }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 134 "chat_lexer.lpp"
{ return _T_HOLD; }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 135 "chat_lexer.lpp"
{ return _T_I; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 136 "chat_lexer.lpp"
{ return _T_IM; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 137 "chat_lexer.lpp"
{ return _T_IS; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 138 "chat_lexer.lpp"
{ return _T_LASSAT; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 139 "chat_lexer.lpp"
{ return _T_LETS; }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 140 "chat_lexer.lpp"
{ return _T_ME; }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 141 "chat_lexer.lpp"
{ return _T_MORE; }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 142 "chat_lexer.lpp"
{ return _T_NEED; }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 143 "chat_lexer.lpp"
{ return _T_NO; }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 144 "chat_lexer.lpp"
{ return _T_NOW; }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 145 "chat_lexer.lpp"
{ return _T_OFCOURSE; }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 146 "chat_lexer.lpp"
{ return _T_OK; }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 147 "chat_lexer.lpp"
{ return _T_ON; }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 148 "chat_lexer.lpp"
{ return _T_PLACE; }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 149 "chat_lexer.lpp"
{ return _T_POSSESSION; }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 150 "chat_lexer.lpp"
{ return _T_POWER; }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 151 "chat_lexer.lpp"
{ return _T_PUMPING; }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 152 "chat_lexer.lpp"
{ return _T_PUT; }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 153 "chat_lexer.lpp"
{ return _T_READY; }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 154 "chat_lexer.lpp"
{ return _T_REQUIRE; }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 155 "chat_lexer.lpp"
{ return _T_ROGER; }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 156 "chat_lexer.lpp"
{ return _T_RUSH; }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 157 "chat_lexer.lpp"
{ return _T_SEC; }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 158 "chat_lexer.lpp"
{ return _T_SEE; }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 159 "chat_lexer.lpp"
{ return _T_SOME; }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 160 "chat_lexer.lpp"
{ return _T_STATUS; }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 161 "chat_lexer.lpp"
{ return _T_STOP; }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 162 "chat_lexer.lpp"
{ return _T_SURE; }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 163 "chat_lexer.lpp"
{ return _T_THANK_YOU; }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 164 "chat_lexer.lpp"
{ return _T_THANKS; }
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 165 "chat_lexer.lpp"
{ return _T_THE; }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 166 "chat_lexer.lpp"
{ return _T_U; }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 167 "chat_lexer.lpp"
{ return _T_UNITS; }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 168 "chat_lexer.lpp"
{ return _T_VTOLS; }
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 169 "chat_lexer.lpp"
{ return _T_WAIT; }
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 170 "chat_lexer.lpp"
{ return _T_WHERE; }
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 171 "chat_lexer.lpp"
{ return _T_YES; }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 172 "chat_lexer.lpp"
{ return _T_YES; }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 173 "chat_lexer.lpp"
{ return _T_YES; }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 174 "chat_lexer.lpp"
{ return _T_YES; }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 175 "chat_lexer.lpp"
{ return _T_YOU; }
	YY_BREAK
/* <<EOF>>					{ return _T_EOF; } */
case 83:
YY_RULE_SETUP
#line 179 "chat_lexer.lpp"
{
								playerIndex = getPlayerFromString(chat_text);

								if(playerIndex >= 0)
								{
									//console( "matched 'player'");
									chat_lval.ival = playerIndex;

									return R_PLAYER;
								}

							}
	YY_BREAK
/* [^ \t\n\<\>\[\]\(\)]+		{ return T_WORD; } */
/* [^ \t\n]+					{ console( "matched 'T_WORD'"); return T_WORD; } */
/* Skip white space */
case 84:
/* rule 84 can match eol */
YY_RULE_SETUP
#line 197 "chat_lexer.lpp"
;
	YY_BREAK
/* Match anything that's been missed and pass it as a char */
/* .							{console( "matched 'anything else '%s'", chat_text[0]); return chat_text[0];} */
case 85:
YY_RULE_SETUP
#line 203 "chat_lexer.lpp"
ECHO;
	YY_BREAK
#line 1517 "chat_lexer.cpp"
case YY_STATE_EOF(INITIAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed chat_in at a new source and called
			 * chat_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = chat_in;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( chat_wrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * chat_text, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of chat_lex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					chat_realloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			chat_restart(chat_in  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) chat_realloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;

	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 262 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 262 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 261);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;

	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					chat_restart(chat_in );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( chat_wrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve chat_text */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )

    chat_lineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 *
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void chat_restart  (FILE * input_file )
{

	if ( ! YY_CURRENT_BUFFER ){
        chat_ensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            chat__create_buffer(chat_in,YY_BUF_SIZE );
	}

	chat__init_buffer(YY_CURRENT_BUFFER,input_file );
	chat__load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 *
 */
    void chat__switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		chat_pop_buffer_state();
	 *		chat_push_buffer_state(new_buffer);
     */
	chat_ensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	chat__load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (chat_wrap()) processing, but the only time this flag
	 * is looked at is after chat_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void chat__load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	chat_in = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 *
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE chat__create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) chat_alloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in chat__create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) chat_alloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in chat__create_buffer()" );

	b->yy_is_our_buffer = 1;

	chat__init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with chat__create_buffer()
 *
 */
    void chat__delete_buffer (YY_BUFFER_STATE  b )
{

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		chat_free((void *) b->yy_ch_buf  );

	chat_free((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a chat_restart() or at EOF.
 */
    static void chat__init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;

	chat__flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then chat__init_buffer was _probably_
     * called from chat_restart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;

	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 *
 */
    void chat__flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		chat__load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *
 */
void chat_push_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	chat_ensure_buffer_stack();

	/* This block is copied from chat__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from chat__switch_to_buffer. */
	chat__load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *
 */
void chat_pop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	chat__delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		chat__load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void chat_ensure_buffer_stack (void)
{
	int num_to_alloc;

	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)chat_alloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in chat_ensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)chat_realloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in chat_ensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 *
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE chat__scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) chat_alloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in chat__scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	chat__switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to chat_lex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 *
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       chat__scan_bytes() instead.
 */
YY_BUFFER_STATE chat__scan_string (yyconst char * yystr )
{

	return chat__scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to chat_lex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 *
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE chat__scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) chat_alloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in chat__scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = chat__scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in chat__scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

[[ noreturn ]] static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up chat_text. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		chat_text[chat_leng] = (yy_hold_char); \
		(yy_c_buf_p) = chat_text + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		chat_leng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 *
 */
int chat_get_lineno  (void)
{

    return chat_lineno;
}

/** Get the input stream.
 *
 */
FILE *chat_get_in  (void)
{
        return chat_in;
}

/** Get the output stream.
 *
 */
FILE *chat_get_out  (void)
{
        return chat_out;
}

/** Get the length of the current token.
 *
 */
int chat_get_leng  (void)
{
        return chat_leng;
}

/** Get the current token.
 *
 */

char *chat_get_text  (void)
{
        return chat_text;
}

/** Set the current line number.
 * @param line_number
 *
 */
void chat_set_lineno (int  line_number )
{

    chat_lineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 *
 * @see chat__switch_to_buffer
 */
void chat_set_in (FILE *  in_str )
{
        chat_in = in_str ;
}

void chat_set_out (FILE *  out_str )
{
        chat_out = out_str ;
}

int chat_get_debug  (void)
{
        return chat__flex_debug;
}

void chat_set_debug (int  bdebug )
{
        chat__flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from chat_lex_destroy(), so don't allocate here.
     */

    /* We do not touch chat_lineno unless the option is enabled. */
    chat_lineno =  1;

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    chat_in = stdin;
    chat_out = stdout;
#else
    chat_in = (FILE *) 0;
    chat_out = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * chat_lex_init()
     */
    return 0;
}

/* chat_lex_destroy is for both reentrant and non-reentrant scanners. */
int chat_lex_destroy  (void)
{

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		chat__delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		chat_pop_buffer_state();
	}

	/* Destroy the stack itself. */
	chat_free((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * chat_lex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *chat_alloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *chat_realloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void chat_free (void * ptr )
{
	free( (char *) ptr );	/* see chat_realloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 203 "chat_lexer.lpp"



/* Set the current input buffer for the lexer */
void chatSetInputBuffer(const char *pBuffer, UDWORD size)
{
	pInputBuffer = pBuffer;
	pEndBuffer = pBuffer + size;

	/* Reset the lexer in case it's been used before */
	chat__flush_buffer(YY_CURRENT_BUFFER);
}

void chatGetErrorData(int *pLine, char **ppText)
{
	*pLine = chat_lineno;
	*ppText = chat_text;
}

int chat_wrap(void)
{
	return 1;
}


/* Older GNU Flex versions don't define chat_lex_destroy()
 * (and neither define a subminor version)
 */
#if !defined(YY_FLEX_SUBMINOR_VERSION) || (YY_FLEX_SUBMINOR_VERSION < 9)
int chat_lex_destroy(void)
{
	/* For non-reentrant C scanner only. */
	chat__delete_buffer(YY_CURRENT_BUFFER);
	yy_init = 1;
	return 0;
}
#endif
