/******************************************************************************
 *                    _   _____   __________                                  *
 *                   | | / / _ | / __/_  __/     Visibility                   *
 *                   | |/ / __ |_\ \  / /          Across                     *
 *                   |___/_/ |_/___/ /_/       Space and Time                 *
 *                                                                            *
 * This file is part of VAST. It is subject to the license terms in the       *
 * LICENSE file found in the top-level directory of this distribution and at  *
 * http://vast.io/license. No part of VAST, including this file, may be       *
 * copied, modified, propagated, or distributed except according to the terms *
 * contained in the LICENSE file.                                             *
 ******************************************************************************/

#include "vast/format/writer.hpp"

#include "vast/error.hpp"
#include "vast/format/writer_factory.hpp"
#include "vast/table_slice.hpp"

namespace vast::format {

caf::expected<std::unique_ptr<format::writer>>
writer::make(std::string output_format, const caf::settings& options) {
  return factory<format::writer>::make(output_format, options);
}

writer::~writer() {
  // nop
}

caf::expected<void> writer::flush() {
  return caf::no_error;
}

} // namespace vast::format
