# stm32f4
This crate provides an autogenerated API for access to STM32F4 peripherals.
The API is generated using [svd2rust] with patched svd files containing
extensive type-safe support. For more information please see the [main repo].

Refer to the [documentation] for full details.

[svd2rust]: https://github.com/rust-embedded/svd2rust
[main repo]: https://github.com/stm32-rs/stm32-rs
[documentation]: https://docs.rs/stm32f4/latest/stm32f4/

## Usage
Each device supported by this crate is behind a feature gate so that you only
compile the device(s) you want. To use, in your Cargo.toml:

```toml
[dependencies.stm32f4]
version = "0.15.1"
features = ["stm32f401"]
```

The `rt` feature is enabled by default and brings in support for `cortex-m-rt`.
To disable, specify `default-features = false` in `Cargo.toml`.

In your code:

```rust
use stm32f4::stm32f401;

let mut peripherals = stm32f401::Peripherals::take().unwrap();
let gpioa = &peripherals.GPIOA;
gpioa.odr.modify(|_, w| w.odr0().set_bit());
```

For full details on the autogenerated API, please see:
https://docs.rs/svd2rust/0.24.1/svd2rust/#peripheral-api

## Supported Devices

| Module | Devices | Links |
|:------:|:-------:|:-----:|
| stm32f401 | STM32F401 | [RM0368](https://www.st.com/resource/en/reference_manual/dm00096844.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f401.html) |
| stm32f405 | STM32F405, STM32F415 | [RM0090](https://www.st.com/resource/en/reference_manual/dm00031020.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f405-415.html) |
| stm32f407 | STM32F407, STM32F417 | [RM0090](https://www.st.com/resource/en/reference_manual/dm00031020.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f407-417.html) |
| stm32f410 | STM32F410 | [RM0401](https://www.st.com/resource/en/reference_manual/dm00180366.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f410.html) |
| stm32f411 | STM32F411 | [RM0383](https://www.st.com/resource/en/reference_manual/dm00119316.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f411.html) |
| stm32f412 | STM32F412 | [RM0402](https://www.st.com/resource/en/reference_manual/dm00180369.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f412.html) |
| stm32f413 | STM32F413, STM32F423 | [RM0430](https://www.st.com/resource/en/reference_manual/dm00305666.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f413-423.html) |
| stm32f427 | STM32F427, STM32F437 | [RM0090](https://www.st.com/resource/en/reference_manual/dm00031020.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f427-437.html) |
| stm32f429 | STM32F429, STM32F439 | [RM0090](https://www.st.com/resource/en/reference_manual/dm00031020.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f429-439.html) |
| stm32f446 | STM32F446 | [RM0390](https://www.st.com/resource/en/reference_manual/dm00135183.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f446.html) |
| stm32f469 | STM32F469, STM32F479 | [RM0386](https://www.st.com/resource/en/reference_manual/dm00127514.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f469-479.html) |
