% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mxinv.R
\name{mxinv}
\alias{mxinv}
\title{Numerical and Symbolic Matrix Inverse}
\usage{
mxinv(x)
}
\arguments{
\item{x}{\code{numeric} or \code{character} matrix.}
}
\value{
\code{numeric} or \code{character} matrix.
}
\description{
Computes the inverse of a \code{numeric} or \code{character} matrix.
}
\examples{
### numeric matrix
x <- matrix(1:4, nrow = 2, byrow = TRUE)
mxinv(x)

### symbolic matrix
x <- matrix(letters[1:4], nrow = 2, byrow = TRUE)
mxinv(x)

}
\references{
Guidotti E (2022). "calculus: High-Dimensional Numerical and Symbolic Calculus in R." Journal of Statistical Software, 104(5), 1-37. \doi{10.18637/jss.v104.i05}
}
\seealso{
Other matrix algebra: 
\code{\link{mxdet}()},
\code{\link{mxtr}()},
\code{\link{mx}()}
}
\concept{matrix algebra}
