\name{plotNetworkWiring}
\alias{plotNetworkWiring}
\title{
 Plot the wiring of a Boolean network
}
\description{
Plots the wiring of genes (i.e. the gene dependencies) of a synchronous or probabilistic Boolean network. The nodes of the graph are the genes, and the directed edges show the dependencies of the genes. This requires the \pkg{igraph} package.
}
\usage{
plotNetworkWiring(network, 
                  layout = layout.fruchterman.reingold, 
                  plotIt = TRUE, ...)
}
\arguments{
  \item{network}{
	A network structure of class \code{BooleanNetwork}, \code{SymbolicBooleanNetwork} or \code{ProbabilisticBooleanNetwork}. These networks can be read from files by \code{\link{loadNetwork}}, generated by \if{latex}{\cr}\code{\link{generateRandomNKNetwork}}, or reconstructed by \code{\link{reconstructNetwork}}.
}
  \item{layout}{
A layouting function that determines the placement of the nodes in the graph. Please refer to the \code{\link[igraph]{layout}} manual entry in the \pkg{igraph} package for further details. By default, the Fruchterman-Reingold algorithm is used.
}
  \item{plotIt}{
If this is true, a plot is generated. Otherwise, only an object of class \code{igraph} is returned, but no plot is drawn.
}
  \item{\dots}{
Further graphical parameters to be passed to \code{\link[igraph:plot.graph]{plot.igraph}}.
}
}
\details{
	This function uses the \code{\link[igraph:plot.graph]{plot.igraph}} function from the \pkg{igraph} package. The plots are customizeable using the \code{\dots} argument. For details on possible parameters, please refer to \code{\link[igraph:plot.common]{igraph.plotting}}.
}
\value{
	Returns an invisible object of class \code{igraph} containing the wiring graph.
}

\seealso{
\code{\link{loadNetwork}}, \code{\link{generateRandomNKNetwork}}, \code{\link{reconstructNetwork}}, \code{\link{plotStateGraph}}, \code{\link[igraph:plot.graph]{igraph.plotting}}
}
\examples{
\dontrun{
# load example data
data(cellcycle)

# plot wiring graph
plotNetworkWiring(cellcycle)
}
}