//---------------------------------------------------------------------------
//
// "" for ʳβʳβ
// 󥸥
//
//      Programed by NAKAUE.T (Meister)
//
//  2001.05.27  Phase 5.1     󥿡ץ꥿ѥ鲽
//                            饹
//  2001.05.31  Phase 5.2     ݼŪpiro
//  2001.06.09  Phase 5.3     ޥåȥ
//  2001.06.10  Phase 5.3.1   Ĵ
//  2001.06.17  Phase 5.4     save
//  2001.08.25  Phase 7.0     ƥк(WriteProtect)
//  2001.12.08  Phase 7.1.2   ƥȥեɤ߹б
//  2002.03.10  Phase 7.9.0   Parsebase˰ư
//                            ƥȥեɤ߹ߤ򳰤(KISʤΡ)
//                            ⤽FISγȯߤǰ̣ΤʤʤäƤ
//                            TNS_Engine_baseѻ
//                            ĤǤ˥ޥåѻ
//                            񥢥󥿡ե
//  2002.04.18  Phase 8.0.0   VMѹɽ
//                            SAORIб
//  2005.06.28  Phase 8.2.3   DecodeEntryName夨GetEntryRangeƳ
//
//---------------------------------------------------------------------------
#ifndef KAWARI_ENGINE_H
#define KAWARI_ENGINE_H
//---------------------------------------------------------------------------
#include "config.h"
//---------------------------------------------------------------------------
#include <string>
#include <vector>
#include <set>
using namespace std;
//---------------------------------------------------------------------------
#include "libkawari/kawari_compiler.h"
#include "libkawari/kawari_dict.h"
#include "libkawari/kawari_code.h"
#include "libkawari/kawari_vm.h"
#include "libkawari/kawari_log.h"
#include "saori/saori.h"
//---------------------------------------------------------------------------
struct TEntryRange;
//---------------------------------------------------------------------------
class TKawariEngine {
private:
	// եΥѥ̾
	string DataPath;

	// 
	TKawariLogger *logger;

	// 
	TNS_KawariDictionary *Dictionary;

	// ץȥ󥸥
	class TKawariVM *KawariVM;

	// SAORI
	class saori::TSaoriPark *SaoriPark;

public:
	// ϰϳΥǥå
	static const unsigned int NPos;

	// API

	// ñ
	//  : ñθĿ
	unsigned int WordCollectionSize(void) const;

	// ͭȥ
	//  : ȥθĿ
	unsigned int EntryCollectionSize(void) const;

	// ꤵ줿ȥñ
	//  : ñθĿ
	unsigned int EntrySize(const string& entryname) const;


	// ȥ̾API

	// ʸ򥨥ȥ̾ǻѲǽʸ˥󥳡ɤ
	static string EncodeEntryName(const string &orgsen);

	// ʸ򥨥ȥ̾ȥǥå˥ǥɤ
	//  : Entry        ñȤΥȥ̾
	//      Entry[i]     ȥiܤ
	//      Entry[i..j]  ȥiܤjܤޤǤ
	//      ǥåξϡ
	//  :  0=ź̵
	//           1=ñǻ
	//           2=ϰϻ
	//          -1=顼
//	static int DecodeEntryName(const string &orgsen,string &entryname,int &st,int &end);
	// ͤϰϤɬ0ʾˤʤ뤬ȥꥵȤϸ¤ʤ
	TEntryRange GetEntryRange(const string &orgsen);

	// IDѴAPI

	// ñID
	//  : 1ꥸ󡢸Ĥʤ0֤
	TWordID GetWordID(const string& word) const;

	// IDñѴ
	//  : եѥ뤷ñʸ
	string GetWordFromID(TWordID id) const;

	// ȥ
	//  : 1ꥸ󡢸Ĥʤ0֤
	TEntry GetEntry(const string& entryname) const;


	// ɲáAPI

	// ȥ
	// ˥ȥ꤬¸ߤϡID֤
	//  : ȥID
	TEntry CreateEntry(const string& entryname);

	// ñ
	// ñ줬¸ߤϡID֤
	//  : ñID
	TWordID CreateWord(const string& word);
	TWordID CreateStrWord(const string& word);

	// ꤵ줿ȥˤ
	// ˶ȥñ줬ĤäƤɤ
	void ClearEntry(const string& entryname);

	// ȥǸؤñɲ
	//  : true
	void Push(const string& entryname,const string& word);

	// ȥǸñκ
	void Pop(const string& entryname);

	// ȥؤñ
	void Insert(const string& entryname,unsigned int pos,const string& word);

	// ȥñκ
	// end뤳Ȥա
	void Erase(const string& entryname,unsigned int st,unsigned int end);

	// ȥñؤ
	void Replace(const string& entryname,unsigned int pos,const string& word);

	// ȥñؤ(ǥåϰϳξ硢id2ɲ)
	void Replace2(const string& entryname,unsigned int pos,const string& word,const string& word2);

	// ꤵ줿ȥˤƤñɲ
	// ȥѿŪѤ˻Ѥ
	void PushAfterClear(const string& entryname,const string& word);
	void PushStrAfterClear(const string& entryname,const string& word);

	// ꤵ줿ȥؤν񤭹ߤػߤ
	void WriteProtect(const string& entryname);

	// ꤵ줿ȥ̾Ϥޤ륨ȥƶˤ
	// ˶ȥñ줬ĤäƤɤ
	// "."ȥꡦ
	void ClearTree(const string& spacename);


	// API

	// ꤵ줿ȥ꤬ɤ
	//  : ʤtrue
	bool Empty(const string& entryname) const;

	// ꤵ줿ȥλꤷ(0ꥸ)ñ֤
	//  : եѥ뤷ñʸ
	string IndexWord(TEntry entry,unsigned int index=0) const;
	string IndexWord(const string& entryname,unsigned int index=0) const;

	// ꤵ줿ȥ⤫ꤷñ򸡺
	//  : ǥå(ĤʤNPos)
	unsigned int Find(const string& entryname,const string& word,unsigned int pos=0) const;

	// ꤵ줿ȥ⤫ꤷñ򸡺(ս)
	//  : ǥå(ĤʤNPos)
	unsigned int RFind(const string& entryname,const string& word,unsigned int pos=NPos) const;

	// ȥ꽸黻Ԥ̤󤹤
	//  : ñθĿ
	unsigned int CalcEntryExpression(const string &entryexpr, set<TWordID> &wordcol) const;

	// ȥ
	//  : ȥθĿ
	unsigned int FindAllEntry(vector<TEntry> &entrycol) const;


	// ¹ԷAPI

	// ꤵ줿ȥλꤷ(0ꥸ)ñ¹Ԥ
	//  string : 
	string IndexParse(TEntry entry,unsigned int index=0);
	string IndexParse(const string& entryname,unsigned int index=0);

	// ꤵ줿IDñ(ץ)¹Ԥ
	//  string : 
	string Parse(TWordID id);

	// Ϳ줿ץȤᡦ¹Ԥ
	//  string : 
	string Parse(const string& script);

	// KISؿ(ӥȥڤӥ桼)μ¹
	string FunctionCall(const vector<string> &args);

	// ӥȥؿξ
	// name : ()ؿ̾
	// info : ()ؿ̾ʸˡͤ͡Υꥹ
	// (bool) : ؿ¸ߤtrue
	bool GetFunctionInfo(const std::string &name, struct TKisFunctionInfo &info);

	// ӥȥؿΥꥹ
	// list : ()ؿ̾ꥹ
	// (unsigned int) : ؿο
	unsigned int GetFunctionList(std::vector<std::string> &list) const;


	// SAORIطAPI

	enum SAORILOADTYPE {
		PRELOAD=saori::PRELOAD,
		LOADONCALL,
		NORESIDENT
	};

	// SAORI⥸塼Ͽ
	void RegisterSAORIModule(const std::string &aliasname, const std::string &path, const SAORILOADTYPE type);

	// SAORI⥸塼Ͽκ
	void EraseSAORIModule(const std::string &aliasname);

	// SAORIꥯȤԤ
	bool RequestToSAORIModule(
		const std::string &aliasname,
		const TPHMessage &request, TPHMessage &response);

	// Ͽ줿SAORI⥸塼ΥꥹȤ
	int ListSAORIModule(std::vector<string> &list);

	// SAORI⥸塼ξ


	// ƥȴط API

	// 򻲾
	string GetHistory(int index);


	// եAPI

	// եΥѥ̾ꤹ
	void SetDataPath(const string &datapath);

	// եΥѥ̾
	string GetDataPath(void) const;

	// եޥåȼեɤ߹
	//  : true
	bool LoadKawariDict(const string &filename);

	// եޥåȼե񤭹
	//  : true
	bool SaveKawariDict(const string &filename,const vector<string>& entry,bool crypt=false) const;

public:

	// μ
	TKawariLogger &GetLogger(void) const;

	TKawariEngine(void);

	~TKawariEngine();

};
//---------------------------------------------------------------------------
// ȥΰ
// range == false : no index (Start=0, End=max(Size()-1, 0))
// start == end : single word
// start < end  : multiple words
// start == TKawariEngine::NPos  : error
struct TEntryRange {
	string Name;
	TEntry Entry;
	bool Range;
	unsigned int Start;
	unsigned int End;

	TEntryRange(const string &name, const TEntry &entry)
		:Name(name), Entry(entry), Range(false),
		 Start(0), End((entry.Size()>0)?entry.Size()-1:0) {}
	TEntryRange(const string &name, const TEntry &entry,
				unsigned int start, unsigned int end)
		:Name(name), Entry(entry), Range(true), Start(start), End(end) {}
	TEntryRange(const TEntryRange &range)
		:Name(range.Name), Entry(range.Entry),
		 Range(range.Range), Start(range.Start), End(range.End) {}
};
//---------------------------------------------------------------------------
// ñ
inline unsigned int TKawariEngine::WordCollectionSize(void) const
{
	return(Dictionary->WordCollectionSize());
}
//---------------------------------------------------------------------------
// ͭȥ
inline unsigned int TKawariEngine::EntryCollectionSize(void) const
{
	return(Dictionary->Size());
}
//---------------------------------------------------------------------------
// ꤵ줿ȥñ
inline unsigned int TKawariEngine::EntrySize(const string& entryname) const
{
	return(Dictionary->GetEntry(entryname).Size());
}
//---------------------------------------------------------------------------
// ñID
inline TWordID TKawariEngine::GetWordID(const string& word) const
{
	TKVMCode_base *code=TKawariCompiler::Compile(word, GetLogger());
	TWordID id=Dictionary->GetWordID(code);
	delete code;

	return(id);
}
//---------------------------------------------------------------------------
// ȥ
inline TEntry TKawariEngine::GetEntry(const string& entryname) const
{
	return(Dictionary->GetEntry(entryname));
}
//---------------------------------------------------------------------------
// ȥ
inline TEntry TKawariEngine::CreateEntry(const string& entryname)
{
	return(Dictionary->CreateEntry(entryname));
}
//---------------------------------------------------------------------------
// ñ
inline TWordID TKawariEngine::CreateWord(const string& word)
{
	return(Dictionary->CreateWord(TKawariCompiler::Compile(word, (*logger))));
}
//---------------------------------------------------------------------------
inline TWordID TKawariEngine::CreateStrWord(const string& word)
{
	return(Dictionary->CreateWord(TKawariCompiler::CompileAsString(word)));
}
//---------------------------------------------------------------------------
// ꤵ줿ȥˤ
inline void TKawariEngine::ClearEntry(const string& entryname)
{
	Dictionary->GetEntry(entryname).Clear();
}
//---------------------------------------------------------------------------
// ؤñɲ
inline void TKawariEngine::Push(const string& entryname,const string& word)
{
	Dictionary->CreateEntry(entryname).Push(CreateWord(word));
}
//---------------------------------------------------------------------------
// ȥǸñκ
inline void TKawariEngine::Pop(const string& entryname)
{
	Dictionary->GetEntry(entryname).Pop();
}
//---------------------------------------------------------------------------
// ȥؤñ
inline void TKawariEngine::Insert(const string& entryname,unsigned int pos,const string& word)
{
	Dictionary->CreateEntry(entryname).Insert(pos,CreateWord(word));
}
//---------------------------------------------------------------------------
// ȥñκ
inline void TKawariEngine::Erase(const string& entryname,unsigned int st,unsigned int end)
{
	Dictionary->GetEntry(entryname).Erase(st, end);
}
//---------------------------------------------------------------------------
// ȥñؤ
inline void TKawariEngine::Replace(const string& entryname,unsigned int pos,const string& word)
{
	Dictionary->CreateEntry(entryname).Replace(pos,CreateWord(word));
}
//---------------------------------------------------------------------------
// ȥñؤ(ǥåϰϳξ硢id2ɲ)
inline void TKawariEngine::Replace2(const string& entryname,unsigned int pos,const string& word,const string& word2)
{
	Dictionary->CreateEntry(entryname).Replace2(pos,CreateWord(word),CreateWord(word2));
}
//---------------------------------------------------------------------------
// ꤵ줿ȥˤƤñɲ
inline void TKawariEngine::PushAfterClear(const string& entryname,const string& word)
{
	Dictionary->CreateEntry(entryname).PushAfterClear(CreateWord(word));
}
//---------------------------------------------------------------------------
inline void TKawariEngine::PushStrAfterClear(const string& entryname,const string& word)
{
	Dictionary->CreateEntry(entryname).PushAfterClear(CreateStrWord(word));
}
//---------------------------------------------------------------------------
// ꤵ줿ȥؤν񤭹ߤػߤ
inline void TKawariEngine::WriteProtect(const string& entryname)
{
	Dictionary->CreateEntry(entryname).WriteProtect();
}
//---------------------------------------------------------------------------
// ꤵ줿ȥ꤬ɤ
//  : ʤtrue
inline bool TKawariEngine::Empty(const string& entryname) const
{
	return(GetEntry(entryname).Size()==0);
}
//---------------------------------------------------------------------------
// ꤵ줿ȥλꤷ(0ꥸ)ñ֤
inline string TKawariEngine::IndexWord(TEntry entry,unsigned int index) const
{
	TWordID id=entry.Index(index);
	if(id==0) return("");
	return(GetWordFromID(id));
}
//---------------------------------------------------------------------------
inline string TKawariEngine::IndexWord(const string& entryname,unsigned int index) const
{
	return(GetWordFromID(Dictionary->GetEntry(entryname).Index(index)));
}
//---------------------------------------------------------------------------
// ꤵ줿ȥ⤫ꤷñ򸡺
//  : ǥå(ĤʤNPos)
inline unsigned int TKawariEngine::Find(const string& entryname,const string& word,unsigned int pos) const
{
//	return(Find(GetEntryID(entryname),GetWordID(word),pos));
	return Dictionary->GetEntry(entryname).Find(GetWordID(word),pos);
}
//---------------------------------------------------------------------------
// ꤵ줿ȥ⤫ꤷñ򸡺(ս)
//  : ǥå(ĤʤNPos)
inline unsigned int TKawariEngine::RFind(const string& entryname,const string& word,unsigned int pos) const
{
//	return(RFind(GetEntryID(entryname),GetWordID(word),pos));
	return Dictionary->GetEntry(entryname).RFind(GetWordID(word),pos);
}
//---------------------------------------------------------------------------
// ȥ̾
inline unsigned int TKawariEngine::FindAllEntry(vector<TEntry> &entrycol) const
{
	return(Dictionary->FindAllEntry(entrycol));
}
//---------------------------------------------------------------------------
// ꤵ줿ȥλꤷ(0ꥸ)ñ֤
inline string TKawariEngine::IndexParse(TEntry entry,unsigned int index)
{
	if(!entry.IsValid()) return("");
	return(Parse(entry.Index(index)));
}
//---------------------------------------------------------------------------
// ꤵ줿ȥλꤷ(0ꥸ)ñ֤
inline string TKawariEngine::IndexParse(const string& entryname,unsigned int index)
{
	return(Parse(Dictionary->GetEntry(entryname).Index(index)));
}
//--------------------------------------------------------------------------
// KISؿ¹Ԥ
inline string TKawariEngine::FunctionCall(const vector<string> &args){
	return KawariVM->FunctionCall(args);
}
//---------------------------------------------------------------------------
// ӥȥؿξ
inline bool TKawariEngine::GetFunctionInfo(const string &name, struct TKisFunctionInfo &info){
	return KawariVM->GetFunctionInfo(name, info);
}
//---------------------------------------------------------------------------
// ӥȥؿΥꥹ
inline unsigned int TKawariEngine::GetFunctionList(vector<string> &list) const{
	return KawariVM->GetFunctionList(list);
}
//--------------------------------------------------------------------------
// 򻲾
inline std::string TKawariEngine::GetHistory(int index){
	return Dictionary->GetHistory(index);
}
//---------------------------------------------------------------------------
// եΥѥ̾ꤹ
inline void TKawariEngine::SetDataPath(const string &datapath)
{
	DataPath=datapath;
}
//---------------------------------------------------------------------------
// եΥѥ̾
inline string TKawariEngine::GetDataPath(void) const
{
	return(DataPath);
}
//---------------------------------------------------------------------------
// μ
inline TKawariLogger &TKawariEngine::GetLogger(void) const
{
	return (*logger);
}
//---------------------------------------------------------------------------
#endif
