# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""UI helpers for collections."""

from functools import cached_property

from debusine.db.models import Collection, CollectionItem
from debusine.web.views.places import Place
from debusine.web.views.ui.base import UI


class CollectionUI(UI[Collection]):
    """UI helpers for Collection instances."""

    @cached_property
    def place(self) -> Place:
        """Return a place to show this collection."""
        return Place(
            title=f"{self.instance.name}@{self.instance.category} collection",
            url=self.instance.get_absolute_url(),
        )

    @cached_property
    def place_search(self) -> Place:
        """Return a place to search this collection."""
        return Place(
            title=f"Search {self.instance.name}@{self.instance.category}"
            " collection",
            url=self.instance.get_absolute_url_search(),
        )


class CollectionItemUI(UI[CollectionItem]):
    """UI helpers for CollectionItem instances."""

    @cached_property
    def place(self) -> Place:
        """Return a place to show this collection item."""
        return Place(
            title=self.instance.name,
            url=self.instance.get_absolute_url(),
        )
